unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, XmlObjModel;

type
  TForm1 = class(TForm)
    Doc: TXmlObjModel;  // Siehe ggf. "Liesmich.txt"
    Button1: TButton;
    Memo1: TMemo;
    procedure Button1Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
var
  NodeList : TXmlNodeList;
  Node : TXmlNode;
  Attr : TXmlNode;
  i, k : integer;
begin
  Doc.LoadDataSource ('.\cd-collection.xml');                          // XML laden
  NodeList := Doc.Document.DocumentElement.SelectNodes ('CD/singer');  // "singer"-Elemente selektieren
  for i := 0 to NodeList.Length-1 do                                   // Iterieren ber Ergebnis-Menge
  begin
    Node := NodeList.Item (i);
    Memo1.Lines.Add (Node.Text);
    for k := 0 to Node.Attributes.Length-1 do
    begin
      Attr := Node.Attributes.Item (k);
      Memo1.Lines.Add ('= '+TXmlAttribute (Attr).Name+'='+Attr.NodeValue);
    end;
  end;
end;

end.
